#include "tri.h"
#include "consoleutil.h"
#include <stdio.h>

float Tri::getWidth() {return (b-a).magnitude();}

float Tri::getHeight() {
	// calculate base line, which is a->b
	Vector2 baseSlope = b - a;
	// create perpendicular slope, which goes along the height
	Vector2 perpSlope = baseSlope;
	perpSlope.x = -baseSlope.y;
	perpSlope.y = baseSlope.x;
	// get distance of point C from the base
	Vector2 basePoint;
	float dist;
	Vector2::lineIntersection(a, b, c, c+perpSlope, dist, basePoint);
	if(dist < 0) {
		dist *= -1;
	}
	return dist;
}

#include "rect.h"

void Tri::draw(char letter) {
	Rect area;
	area.add(a);
	area.add(b);
	area.add(c);
	Vector2 i;
	for(i.y = (float)((int)area.min.y); i.y < area.max.y; ++i.y) {
		for(i.x = (float)((int)area.min.x); i.x < area.max.x; ++i.x) {
			if(i.isWithin(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT)
			&& i.isInsideTriangle(a, b, c)) {
				moveCursor((int)i.x, (int)i.y);
				putchar(letter);
			}
		}
	}
}

void Tri::translate(Vector2 delta) {
	a += delta;
	b += delta;
	c += delta;
}

float Tri::getArea() {
	return (getWidth() * getHeight() ) / 2;
}
